/*
  ULNStepper.h - Library to use with controller ULN2003
				 for stepper motors.
				
  Created by A. Carpini, 24 April 2015.
  Contact: alessio.carpini@gmail.com

*/
#ifndef ULNStepper_h
#define ULNStepper_h

#include "Arduino.h"

// Constants that the user passes in to the stepper calls
#define SINGLE 1
#define DOUBLE 2
#define HALF 3

// Constants that the user passes in to the motor calls
#define FORWARD 1
#define BACKWARD 2


class ULNStepper
{
  public:
    ULNStepper(uint16_t steps, uint8_t pin1, uint8_t pin2, uint8_t pin3, uint8_t pin4);
    void setSpeed(uint16_t rpm);
    void step(uint16_t steps, uint8_t dir,  uint8_t style = SINGLE);
	uint8_t onestep(uint8_t dir, uint8_t style);
	
	uint32_t us_per_step, steppingcounter;
	
  private:
    uint8_t _pin1;
	uint8_t _pin2;
	uint8_t _pin3;
	uint8_t _pin4;
	uint16_t _revsteps;
	uint8_t _currentstep;
};

#endif