/*
  ULNStepper Library 
  Library to use with controller ULN2003
  for stepper motors.
				
  Created by A. Carpini, 24 April 2015.
  Contact: alessio.carpini@gmail.com
  
  - Demo Sketch -
  
*/

#include <ULNStepper.h>

// Connect a ULN2003 controller to digital pin 9,10,11 and 12 of Arduino
// Connect to ULN2003 controller board a motor step with 200 steps per
// revolution (1.8 degree)
ULNStepper motor(200, 9, 10, 11, 12);

void setup() {
  
  // set up Serial library at 9600 bps
  Serial.begin(9600);           
  Serial.println("Stepper test!");
  
  // set motor speed to 10 rpm 
  motor.setSpeed(10);    
}

void loop() 
{
  Serial.println("Single coil steps");
  motor.step(100, FORWARD, SINGLE); 
  motor.step(100, BACKWARD, SINGLE); 

  Serial.println("Double coil steps");
  motor.step(100, FORWARD, DOUBLE); 
  motor.step(100, BACKWARD, DOUBLE);

  Serial.println("HALF coil steps");
  motor.step(100, FORWARD, HALF); 
  motor.step(100, BACKWARD, HALF); 
}
